
#ifdef VERTEX_SHADER

layout(location = 0) in vec3 a_position;
layout(location = 1) in vec2 a_texcoord;
out vec2 v_texcoord;

void main(void) {
   v_texcoord = a_texcoord;
   gl_Position = vec4(a_position, 1.0);
}

#else

uniform sampler2D u_texture;
uniform sampler2D u_palette_texture;
uniform float u_palette_index;
in vec2 v_texcoord;
out vec4 out_color;

void main(void) {
   float color_index = texture(u_texture, v_texcoord).r * 255.0;
   const float num_colors = 16.0*4.0 - 1.0;
   float u = (u_palette_index*16.0 + color_index)/num_colors;
   vec3 color = texture(u_palette_texture, vec2(u, 0.0)).rgb;
   out_color = vec4(color, 1.0);
}

#endif
