
#ifdef VERTEX_SHADER

uniform mat4 u_view;
uniform mat4 u_proj;
layout(location = 0) in vec3 a_position;
layout(location = 1) in vec2 a_texcoord;
out vec2 v_texcoord;

void main(void) {
   v_texcoord = a_texcoord;
   gl_Position = u_proj * u_view * vec4(a_position, 1.0);
}

#else

uniform sampler2D u_texture;
in vec2 v_texcoord;
out vec4 out_color;

void main(void) {
   vec4 color = texture(u_texture, v_texcoord);
   if (color.r*255.0 > 15.0) discard;
   out_color = color;
}

#endif

