
#ifdef VERTEX_SHADER

uniform mat4 u_view;
uniform mat4 u_proj;
layout(location = 0) in vec3 a_position;
layout(location = 2) in vec4 a_color;
out vec4 v_color;

void main(void) {
   v_color = a_color;
   gl_Position = u_proj * u_view * vec4(a_position, 1.0);
}

#else

in vec4 v_color;
out vec4 out_color;

void main(void) {
   out_color = v_color;
}

#endif

